# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY WYMAGANE
# Konieczne jest podanie wartości dla każdego z tych parametrów.
# ---------------------------------------------------------------------------------------------------------------------

variable "environment" {
  description = "Nazwa środowiska, w którym będzie przeprowadzone wdrożenie"
  type        = string
}

variable "min_size" {
  description = "Minimalna liczba egzemplarzy EC2 w ASG"
  type        = number
}

variable "max_size" {
  description = "Maksymalna liczba egzemplarzy EC2 w ASG"
  type        = number
}

variable "enable_autoscaling" {
  description = "Wartość true oznacza włączenie automatycznego skalowania"
  type        = bool
}

# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY OPCJONALNE
# Te parametry mają rozsądne wartości domyślne.
# ---------------------------------------------------------------------------------------------------------------------

variable "ami" {
  description = "Obraz AMI do uruchomienia w klastrze"
  type        = string
}

variable "instance_type" {
  description = "Typ egzemplarza EC2 do uruchomienia (np. t2.micro)"
  type        = string
  default     = "t2.micro"
}

variable "server_text" {
  description = "Ciąg tekstowy zwracany przez serwer"
  default     = "Witaj, świecie"
  type        = string
}

variable "server_port" {
  description = "Numer portu używany przez serwer dla żądań HTTP"
  type        = number
  default     = 8080
}

variable "custom_tags" {
  description = "Własne tagi przeznaczone do użycia w egzemplarzach ASG"
  type        = map(string)
  default     = {}
}

variable "db_remote_state_bucket" {
  description = "Nazwa kubełka S3 dla bazy danych informacji o stanie Terraform"
  type        = string
  default     = null
}

variable "db_remote_state_key" {
  description = "Ścieżka dostępu w kubełku S3 dla bazy danych informacji o stanie Terraform"
  type        = string
  default     = null
}

variable "vpc_id" {
  description = "Identyfikator grupy VPC, w której będzie przeprowadzone wdrożenie"
  type        = string
  default     = null
}

variable "subnet_ids" {
  description = "Identyfikatory podsieci, w któych będzie przeprowadzone wdrożenie"
  type        = list(string)
  default     = null
}

variable "mysql_config" {
  description = "Konfiguracja bazy danych MySQL"
  type        = object({
    address = string
    port    = number
  })
  default     = null
}
